********************************************************************************
* Program: Uses CPS Match data to create a measure of education utilization by occupation 
*       for Labor Disparities Conference
* Date: 07/15/2020
* Modified: 11/10/2020
********************************************************************************

***** ONLY USE ORG DATA *************************
keep if mis == 4 | mis == 8 
keep if E == 1

drop if missing(fineoccgroup) | fineoccgroup <= 0
g educunderbach = 1 if educgroup == 1 | educgroup == 2
replace educunderbach = 0 if educgroup == 3 | educgroup == 4

collapse educunderbach [aweight = ernwgt] , by(fineoccgroup year)
*rename educgroup avgeduc
*gen avgeducgroup = 1 if avgeduc < 1.25
*replace avgeducgroup = 2 if avgeduc >= 1.25 & avgeduc < 2.25
*replace avgeducgroup = 3 if avgeduc >= 2.25 & avgeduc < 3.25
*replace avgeducgroup = 4 if avgeduc >= 3.25
keep year educunderbach fineoccgroup
sort year fineoccgroup

save "./Data_cleaning/Data/utildata.dta", replace
